require 'propolize'

# Page object for "propositional" pages, as at http://thinkinghard.com/propositional
class PropositionalPage < Regenerate::PageObject

  # Process by invoking Propolizer to process the source file
  # Instance variables that must be defined beforehand are @template, @title, @author and @date
  def process
    propolizer = Propolize::Propolizer.new()
    @body = propolizer.propolize("_templates/#{@template}.html", 
                                 @source, @fileName, 
                                 {"title" => @title, "author" => @author, 
                                   "date" => @date})
  end
  
end
