/* Copyright 2006 Philip Dorrell.
   Licensed under the General Public License version 2, 
   a copy of which may be found at http://thinkinghard.com/math/integers/gnu-general-public-license.txt
*/   

/** Useage:
    1. Include this file within the header section of the HTML page thus:
    <script language="JavaScript" src="console.js"></script>
    
    2. Invoke the setup function thus:
    <body onload="consoleSetup();">
    
    3. Add the following definitions to your HTML or javascript _before_ this file is included:
    
    var logging=true;
    function log(message) {}
    
    (This means you can uninclude the console.js file without calls to "log" causing errors.
 **/
   
/** Default definition of log function which does nothing. */
function log(line) {}

/** Invoke this setup function on page load to create a console div which
 * is written to by calls to the function "log".*/
function consoleSetup() { 
  if (logging) {
    var console = document.createElement ("div");
    console.style.border="solid"; console.style.padding="0em 1em"; console.style.backgroundColor="#f0d0d0";
    console.fontSize="0.9em";
    document.body.appendChild (console);
    var clearConsoleButton = document.createElement ("input");
    clearConsoleButton.type="button";
    clearConsoleButton.name="Clear Console";
    clearConsoleButton.value="Clear Console";
    clearConsoleButton.onclick = function() {
      while (consoleBody.hasChildNodes()) consoleBody.removeChild (consoleBody.firstChild);}
    console.appendChild (clearConsoleButton);
    var consoleBody=document.createElement ("div");
    console.appendChild (consoleBody);
    log = function (line) {
      var lineElement = document.createElement ("div"); 
      lineElement.style.font="9pt 'Courier'";
      var lineText = document.createTextNode (line); 
      lineElement.appendChild (lineText); consoleBody.appendChild (lineElement); 
    }
  }
}
