# Page object for "algebra help" pages, as at http://thinkinghard.com/math/algebrahelp
class AlgebraHelpPage < Regenerate::PageObject
    
  
  # Regex to parse date of form '23 May, 2014'
  DATE_REGEX = /[0-9]+[ ]+[A-Za-z]+,[ ]+([0-9]+)/

  # Process the blog page object. 
  # Required instance variables to be set before hand are @title and @dateString
  # Instance variables that get updated are @header, @footer
  def process
    dateMatch = DATE_REGEX.match(@dateString)
    if dateMatch
      @year = dateMatch[1].to_i
      puts " parsed @year = #{@year} from #{@dateString.inspect}"
    else
      raise Exception.new("Invalid date string: #{@dateString.inspect}")
    end
    @header=erb("_templates/_header.html")
    @footer=erb("_templates/_footer.html")
  end
  
end
