puts "Loading #{__FILE__} ..."
puts " regenerate source (or output) file or directory: #{path}"

# Determine the fully expanded name of the directory containing this script
baseDir = File.expand_path(File.dirname(__FILE__), Dir.pwd)

puts " baseDir = #{baseDir}"

# Include Ruby class definitions used by specific groups of source files
require File.join(baseDir, 'src/blog/_blog.rb')
require File.join(baseDir, 'src/math/algebrahelp/_algebraHelp.rb')
require File.join(baseDir, 'src/propositional/_propositional.rb')

# The site generator object which will regenerate whatever portion of the website that we are asked to regenerate
siteGenerator = SiteRegenerator.new(baseDir, "src", "output")

# The following line forces the regenerate script to check that the output is identical to the existing output
# Comment it out if you want to allow output different from existing output (or if there is no existing output)
siteGenerator.checkNoChanges = true

puts "Regenerating path #{path}, checkNoChanges = #{siteGenerator.checkNoChanges}"
# Regenerate the portion of the website specified in the 'path' variable
siteGenerator.regeneratePath(path)

puts "finished running #{__FILE__}."
